; Title - Bitmap Display
; By    - Adam Trionfo
;
;         1.4 - December 6, 2016
;             - Fixed to work with recent versions of MESS/MAME Emulator.
;               Changed Interrupt Mode from $18 to $08 (screen
;               interrupts only).  Must press Reset to begin program properly.
;         1.3 - November 30, 2003
;         1.2 - March 25, 2002
; 
; This program could not have been written without using
; Mike White's "Astro BASIC 4x2 Multicart Loader" and
; and the "Nutting Manual" as a reference.
;
;  
; About this Program
; ------------------ 
;
; This program displays a 4000 byte Astrocade bit-map
; screen
;
; Assembling this Program
; -----------------------
;    This file will assemble with ZMAC 1.3 (a little
; known, freely distributable Z-80 assembler (with C
; source), that has a 25-year history.  ZMAC can be
; compiled under just about any O.S. in existence, so
; try it out. 
;  
; To assemble Z-80 source code using ZMAC:
;  
; zmac -i -m -o <outfile> -x <listfile> <filename>
; 
; For example, to assemble this Astrocade Z-80 program:
;    
; zmac -i -m -o titledis.bin -x titledis.lst titledis.asm

INCLUDE "HVGLIB.H"

        ORG    FIRSTC   ; First byte of Cartridge
        DB     "U"      ; User Cartridge Sentinel

        DW     MENUST   ; Next menu link
        DW     PRGNAM   ; Address of title for program
        DW     PRGST    ; Jump here if prog is selected

BITMAP:
; 4000 byte bitmap graphic
INCLUDE "blankbit.asm"

;       ORG    $2FA7

PRGST:  DI
        SYSTEM (INTPC)

        DO     (SETOUT)
        DB     $B0        ; Vertical Blanking Line
        DB     $2C        ; Left/Right Color Boundary
        DB     00001000B  ; Set Bit 3 of INterrupt MODe (Screen Interrupts Only)
 
        DO     (COLSET)
        DW     COLTAB     ; Color Table

        DO     (MOVE)
        DW     NORMEM     ; Destination
        DW     4000D      ; Bytes to move
        DW     BITMAP     ; Source Address
        EXIT

LOOP:   NOP
        JP     LOOP       ; Infinite loop

        ORG    $2FE7
; Color Table #1
COLTAB: DB     $00        ; Color 3 Left  - Black
        DB     $5A        ; Color 2 Left  - Red
        DB     $77        ; Color 1 Left  - Yellow
        DB     $72        ; Color 0 Left  - Brown
        DB     $00        ; Color 3 Right - Black
        DB     $5A        ; Color 2 Right - Red
        DB     $77        ; Color 1 Right - Yellow
        DB     $72        ; Color 0 Right - Brown

        ORG    $2FEF      ; Program Name
PRGNAM: DB     'D','I','S','P','L','A','Y',' '
        DB     'B','I','T','M','A','P'
        DB     $00        ; End

        ORG    $2FFF
        DB     $00        ; End - Last byte
