; Title - Smurf Bitmap Display
; By    - Adam Trionfo (adapted by Kurt Woloch)
; Rev   - 5.2.19 - February 19th, 2005
; 
; This program could not have been written without using
; Mike White's "Astro BASIC 4x2 Multicart Loader" and
; and the "Nutting Manual" as a reference.
;
;  
; About this Program
; ------------------ 
;
; This program displays a 4000 byte Astrocade bit-map
; screen
;
; Assembling this Program
; -----------------------
;    This file will assemble with ZMAC 1.3 (a little
; known, freely distributable Z-80 assembler (with C
; source), that has a 25-year history.  ZMAC can be
; compiled under just about any O.S. in existence, so
; try it out. 
;  
; To assemble Z-80 source code using ZMAC:
;  
; zmac -i -m -o <outfile> -x <listfile> <filename>
; 
; For example, to assemble this Astrocade Z-80 program:
;    
; zmac -i -m -o smurfdis.bin -x smurfdis.lst smurfdis.asm

INCLUDE "HVGLIB.H"

        ORG    FIRSTC   ; First byte of Cartridge
        DB     "U"      ; User Cartridge Sentinel

        DW     MENUST   ; Next menu link
        DW     PRGNAM   ; Address of title for program
        DW     PRGST    ; Jump here if prog is selected

BITMAP:
; 4000 byte bitmap graphic
INCLUDE "smurfbit.asm" ;Bitmap with smurf picture

;       ORG    $2FA7

PRGST:  DI
        SYSTEM (INTPC)

        DO     (SETOUT)
        DB     $B0        ; Vertical Blanking Line
        DB     $2C        ; Left/Right Color Boundary
        DB     $18        ; interrupt Mode
 
        DO     (COLSET)
        DW     COLTAB     ; Color Table

        DO     (MOVE)
        DW     NORMEM     ; Destination
        DW     4000D      ; Bytes to move
        DW     BITMAP     ; Source Address
        EXIT

LOOP:   NOP
        JP     LOOP       ; Infinite loop

        ORG    $2FE7
; Color Table #1
COLTAB: DB     $00        ; Color 3 Left  - Black
        DB     $03        ; Color 2 Left  - Gray
        DB     $FB        ; Color 1 Left  - Blue
        DB     $07        ; Color 0 Left  - White
        DB     $00        ; Color 3 Right - Black
        DB     $03        ; Color 2 Right - Grey
        DB     $FB        ; Color 1 Right - Blue
        DB     $07        ; Color 0 Right - White

        ORG    $2FEF      ; Program Name
PRGNAM: DB     'S','M','U','R','F',' '
        DB     'M','O','C','K','U','P'
        DB     $00        ; End

        ORG    $2FFF
        DB     $00        ; End - Last byte
