; Title - Smurf Bitmap Display
; By    - Adam Trionfo (adapted by Kurt Woloch)
; Rev   - 5.2.19 - February 19th, 2005

;         1.1  - December 6, 2016
;              - Fixed by Adam Trionfo to work with recent versions of
;                MESS/MAME Emulator.  Changed Interrupt Mode from $18 to $08
;                (screen interrupts only).  Must press Reset to begin
;                program properly.
;         1.01 - February 19th, 2005
;         1.0  - 2005 
; 
; This program could not have been written without using
; Mike White's "Astro BASIC 4x2 Multicart Loader" and
; and the "Nutting Manual" as a reference.
;
;  
; About this Program
; ------------------ 
;
; This program displays a 4000 byte Astrocade bit-map
; screen
;
; Assembling this Program
; -----------------------
;    This file will assemble with ZMAC 1.3 (a little
; known, freely distributable Z-80 assembler (with C
; source), that has a 25-year history.  ZMAC can be
; compiled under just about any O.S. in existence, so
; try it out. 
;  
; To assemble Z-80 source code using ZMAC:
;  
; zmac -i -m -o <outfile> -x <listfile> <filename>
; 
; For example, to assemble this Astrocade Z-80 program:
;    
; zmac -i -m -o smurfdis.bin -x smurfdis.lst smurfdis.asm

INCLUDE "HVGLIB.H"

        ORG    FIRSTC   ; First byte of Cartridge
        DB     "U"      ; User Cartridge Sentinel

        DW     MENUST   ; Next menu link
        DW     PRGNAM   ; Address of title for program
        DW     PRGST    ; Jump here if prog is selected

; Variable section
; Volumes for tone generators
;VOLTONE EQU 2000D
;SAVE_E EQU 2048D ;we need to save E here because we run out of registers to use
BITMAP:
; 4000 byte bitmap graphic
INCLUDE "smurfbit.asm" ;Bitmap with smurf picture

;       ORG    $2FA7

PRGST:  DI
        SYSTEM (INTPC)

        DO     (SETOUT)
        DB     $C0        ; Vertical Blanking Line
        DB     $2C        ; Left/Right Color Boundary
        DB     00001000B  ; Set Bit 3 of INterrupt MODe (Screen Interrupts Only)
 
        DO     (COLSET)
        DW     COLTAB     ; Color Table

        DO     (MOVE)
        DW     NORMEM     ; Destination
        DW     4000D      ; Bytes to move
        DW     BITMAP     ; Source Address
        EXIT

LOOP:   NOP
        JP     MUSPROC       ; Jump to music processing (at $3000)
        
        ORG    $2FE7

; Color Table #1
COLTAB: DB     $00        ; Color 3 Left  - Black
        DB     $03        ; Color 2 Left  - Gray
        DB     $FB        ; Color 1 Left  - Blue
        DB     $07        ; Color 0 Left  - White
        DB     $00        ; Color 3 Right - Black
        DB     $03        ; Color 2 Right - Grey
        DB     $FB        ; Color 1 Right - Blue
        DB     $07        ; Color 0 Right - White

        ORG    $2FEF      ; Program Name
PRGNAM: DB     'S','M','U','R','F',' '
        DB     'M','O','C','K','U','P'
        DB     $00        ; End

        ORG    $2FFF
        DB     $00        ; End - Last byte

;ORG $3000

NOTE_VOLUME EQU 20384D
TICK_IN_DECAY EQU 20387D
TICK_IN_NOTE EQU 20388D
CURRENT_NOTE EQU 20389D

;OK, we fouled up here. I'll try to give some pseudo-code in BASIC first.
 MUSPROC:
;  
;   for i = 3 to 1 step -1
;      DECAY(i) = 0
;   next i
;   Master_Osc = 30
;   Tick_in_Decay = 0
;   Tick_in_Note = 0
;   Current_Note = 0
;   EI
; 
; Here's the Z80 version of this:

EI
LD B, 2 ;set i to 2
LD A, 16 ; load value to set
LD IX, NOTE_VOLUME
LD (IX), A
LD (IX+1), A
LD (IX+2), A

LD A, 30
OUT (TONMO),A ;Initialize master oscillator

LD IX, TICK_IN_DECAY
LD (IX), 1
LD IX, TICK_IN_NOTE
LD (IX), 7
LD IX, CURRENT_NOTE
LD (IX), 0
 
LD A, 0
OUT  (VIBRA),A ;Write 0 to vibrato register
OUT (VOLN),A ;Write 0 to noise register... we don't want to output noise... yet.
LD A, 15
OUT (VOLAB),A
OUT (VOLC),A

; VBLANKLOOP:
;   HALT
;   Tick_in_Decay = Tick_in_Decay + 1
;   If Tick_in_Decay = 2 Then
;     Call Decay_Notes
;     Tick_in_Decay = 0
;  End If
;
;  Tick_in_Note = Tick_in_Note + 1
;  If Tick_in_Note = 8 Then
;      Call Process_New_Notes
;      Tick_in_Note = 0
;  End If
;  Goto VBLANKLOOP

VBLANKLOOP:
   HALT
   LD HL, TICK_IN_DECAY
   INC (HL)
   LD A, (HL)
   ;OUT (COL1L),A
   CP 2
   JP NZ, NO_DECAY
      CALL DECAY_NOTES
      LD HL, TICK_IN_DECAY
      LD (HL), 0

NO_DECAY:
   
;  Tick_in_Note = Tick_in_Note + 1
;  If Tick_in_Note = 8 Then
;      Call Process_New_Notes
;      Tick_in_Note = 0
;  End If
;  Goto VBLANKLOOP

   LD HL, TICK_IN_NOTE
   INC (HL)
   LD A, (HL)
   ;OUT (COL0L),A
   CP 8
   JP NZ, NO_NOTE
       CALL PROCESS_NEW_NOTES
      LD HL, TICK_IN_NOTE
      LD (HL), 0

NO_NOTE:
   JP VBLANKLOOP

;OK, as you probably noticed, we have 2 subroutines now, which will follow here.
;Sub Decay_Notes()
;   for i = 1 to 3
;      if note_volume(i) > 0 Then
;         note_volume(i) = note_volume(i) - 1
;      End If
;  next i
;  VOLREG1 = note_volume(1) * 16 + note_volume(2)
;  VOLREG2 = note_volume(3)
;End Sub

DECAY_NOTES:
   LD B, 0
   LD HL, NOTE_VOLUME

DECAYLOOP:
   LD A, (HL)
   CP 0
   JP Z, NO_DECAY_TONE

      DEC (HL)

NO_DECAY_TONE:
   INC B
   INC HL
   LD A, B
   CP 3
   JP NZ, DECAYLOOP

   LD IX, NOTE_VOLUME ;set back
   LD A, (IX+1) ;load content of 1st register
   SLA A ;shift left by 4 bits
   SLA A
   SLA A
   SLA A
   LD B, A ;store in B
   LD A, (IX) ;load content of 2nd register
   ADD A, B ;A now contains the write value for the 1st volume register (tone generators 1 and 2)
   OUT (VOLAB),A ;write out this value
   LD A, (IX+2) ;load content of 3rd register
   OUT (VOLC),A; write out to register for 3rd volume
RET

;Sub Process_New_Notes()
; for i = 0 to 2
;    If Mustab(i*64+current_note) > 0 Then
;       GENERATORFREQ(i) = Mustab(i*64+current_note)
;       Note_Volume(i) = 16
;   End If   
; next i

PROCESS_NEW_NOTES:
   LD B, 0 ;B is our index for tone generators
   LD A, B

NEW_NOTE_LOOP:

;Calculate (i*64+current_note)
   SLA A
   SLA A
   SLA A
   SLA A
   SLA A
   SLA A
   ;OUT (COL1L),A ;also write it to color register 1 as a test   
   LD IX, CURRENT_NOTE
   ADD A, (IX) ;now A should contain (i*64+current_note)
   LD HL, MUSTAB
   LD E, A 
   LD D, 0
   ADD HL, DE
   
   LD A, (HL)
   CP 0
   JP Z, NO_WRITE_TONE
       
      LD A, TONEA ;load port no. for tone generator A
      ADD A, B ;add tone generator index
      LD C, A ;transfer A into C (because the OUT command only works with C)
      LD A,(HL) ;load current note again since we overwrote it with port no.
      OUT (c),A ;write it to sound generator #c
      ;OUT (COL0L),A ;also write it to color register 0 as a test

      LD E, B
      LD HL, NOTE_VOLUME
      ADD HL, DE
      LD (HL), 16
   
NO_WRITE_TONE:
   INC B
   LD A, B
   CP 3
   ;CP 2
   JP NZ, NEW_NOTE_LOOP      

; if current_note < 63 then
;    current_note = current_note + 1
; end if
;End Sub

   LD HL, CURRENT_NOTE
   LD A, (HL)
   ;OUT (COL1L),A ;also write it to color register 1 as a test
   CP 63
   JP Z, END_NEW_NOTE
      INC (HL)
END_NEW_NOTE:   
RET

ORG $3100

MUSTAB: DB 39,0,0,0,29,0,0,39,35,0,44,0,52,0,0,0,39,0,0,47,59,0,47,0,52,0,0,0,0,0,0,0
   DB 39,0,0,0,29,0,0,39,35,0,44,0,52,0,0,0,39,0,0,47,59,0,52,0,59,0,0,0,0,0,0,0
;Voice 2
   DB 47,0,0,0,39,0,0,47,44,0,52,0,70,0,0,0,47,0,0,59,79,0,59,0,63,0,0,0,0,0,0,0
   DB 47,0,0,0,39,0,0,47,44,0,52,0,70,0,0,0,47,0,0,59,70,0,63,0,79,0,0,0,0,0,0,0
;Voice 3
   DB 239,0,0,0,189,0,0,0,179,0,142,0,119,0,0,0,239,0,0,0,189,0,0,0,159,0,179,0,189,0,213,0
   DB 239,0,0,0,189,0,0,0,179,0,142,0,119,0,0,0,213,0,0,189,179,0,159,0,239,0,159,0,119,0,0,0

